/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.hardware;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.ImageFileDataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.comm.VirtualDeviceDataTransfer;
import DE.siemens.ad.logo.dialog.CommunicationSettingPanel;
import DE.siemens.ad.logo.model.DrawingProperties;
import DE.siemens.ad.logo.model.EthernetConnection;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.MemoryUsageTable;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.ParameterItemTableLogo7;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AmplifierBlock;
import DE.siemens.ad.logo.model.block.AnalogComparatorBlock;
import DE.siemens.ad.logo.model.block.AnalogDeltaTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogFilterBlock;
import DE.siemens.ad.logo.model.block.AnalogMathsBlock;
import DE.siemens.ad.logo.model.block.AnalogMuxBlock;
import DE.siemens.ad.logo.model.block.AnalogTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogWatchdogBlock;
import DE.siemens.ad.logo.model.block.AndBlock;
import DE.siemens.ad.logo.model.block.AstronomicalClockBlock;
import DE.siemens.ad.logo.model.block.AsymPulseGeneratorBlock;
import DE.siemens.ad.logo.model.block.AverageValueBlock;
import DE.siemens.ad.logo.model.block.ClockBlock;
import DE.siemens.ad.logo.model.block.ComfortSwitchBlock;
import DE.siemens.ad.logo.model.block.CounterBlock;
import DE.siemens.ad.logo.model.block.HoursCounterBlock;
import DE.siemens.ad.logo.model.block.LatchingRelayBlock;
import DE.siemens.ad.logo.model.block.MathDetectionBlock;
import DE.siemens.ad.logo.model.block.MaxMinBlock;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.model.block.NandBlock;
import DE.siemens.ad.logo.model.block.NorBlock;
import DE.siemens.ad.logo.model.block.NotBlock;
import DE.siemens.ad.logo.model.block.OffDelayBlock;
import DE.siemens.ad.logo.model.block.OnDelayBlock;
import DE.siemens.ad.logo.model.block.OnOffDelayBlock;
import DE.siemens.ad.logo.model.block.OrBlock;
import DE.siemens.ad.logo.model.block.PIDBlock;
import DE.siemens.ad.logo.model.block.PWMBlock;
import DE.siemens.ad.logo.model.block.PecAndBlock;
import DE.siemens.ad.logo.model.block.PecNandBlock;
import DE.siemens.ad.logo.model.block.PulseRelayBlock;
import DE.siemens.ad.logo.model.block.RampControlBlock;
import DE.siemens.ad.logo.model.block.RandomBlock;
import DE.siemens.ad.logo.model.block.RetentiveOnDelayBlock;
import DE.siemens.ad.logo.model.block.ShiftRegisterBlock;
import DE.siemens.ad.logo.model.block.SoftkeyBlock;
import DE.siemens.ad.logo.model.block.StairsSwitchBlock;
import DE.siemens.ad.logo.model.block.StopWatchBlock;
import DE.siemens.ad.logo.model.block.TriggerBlock;
import DE.siemens.ad.logo.model.block.WipingRelayBlock;
import DE.siemens.ad.logo.model.block.WipingRelayPECBlock;
import DE.siemens.ad.logo.model.block.XorBlock;
import DE.siemens.ad.logo.model.block.YearClockBlock;
import DE.siemens.ad.logo.model.hardware.Logo6Update1;
import DE.siemens.ad.logo.model.hardware.Logo7UDF;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromHardware;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo7;
import DE.siemens.ad.logo.model.visitor.build.CompilerToHardware;
import DE.siemens.ad.logo.model.visitor.build.CompilerToLogo7;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo7;
import DE.siemens.ad.logo.model.visitor.build.xml.CompileFromXml;
import DE.siemens.ad.logo.model.visitor.build.xml.CompileFromXmlUDF;
import DE.siemens.ad.logo.model.visitor.build.xml.CompileParameterFromXml;
import DE.siemens.ad.logo.model.visitor.build.xml.CompileParameterFromXmlUDF;
import DE.siemens.ad.logo.util.AnchorMemory16V7;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.Memory16;
import DE.siemens.ad.logo.util.MemoryEnumeration;
import DE.siemens.ad.logo.util.MessageMemoryRTF_V7;
import DE.siemens.ad.logo.util.NetworkMemoryV7;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.ProgramMemory16;
import DE.siemens.ad.pdraw.simulation.ActualValueVisitor;
import DE.siemens.ad.pdraw.simulation.ActualValueVisitorV7;
import DE.siemens.ad.udf.UDFBlock;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.dom4j.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logo7
extends Logo6Update1 {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected final int ADR_SLAVE_MASTER_MODE = 271;
    protected final int ADR_EEPROM_INDEX = 4744;
    protected static int ADR_OHC_EXISTED = 17325;
    protected static int ADR_SDCARD_FLAG = 18686;
    protected static int CARD_PROTECTED = 128;
    private transient CompilerToLogo7 fCompilerToLogo;

    @Override
    public int getOrder() {
        return 1600;
    }

    protected static Dictionary getSystemInfo() {
        Hashtable<String, Object> dict = new Hashtable<String, Object>(20);
        dict.put("knownBlocks", Logo7.getBlockNamesArray());
        TimeUnit[] availableTimeUnits = new TimeUnit[]{new Hours(), new Minutes(), new HighResolutionSeconds()};
        dict.put("availableTimeUnits", availableTimeUnits);
        int[] iArr = new int[]{400, Integer.MAX_VALUE, 250, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 24, 16, 0, 0, 27, 8, 50, 2, 8000, 100, 16, 4, 4, 32, 64, 4, 64, 32, 16, 64, 1, 64, 16, 8};
        dict.put("maxValues", iArr);
        dict.put("blockMemoryTable", new BlockMemoryUsage());
        dict.put("blockActualParameterMemory", new BlockActualMemoryUsage());
        dict.put("blockREMMemoryTable", new BlockREMMemoryUsage());
        dict.put("parameterItemTable", new ParameterItemTableLogo7());
        Logo7.addPropertyItems(dict);
        Logo7.addSupportItems(dict);
        return dict;
    }

    protected static String[][] getBlockNamesArray() {
        String[][] sArr = new String[][]{{"Constant", "Input", "NetworkNode", "AnalogNetworkNode", "KeyInput", "TDFunctionKeyInput", "Output", "Marker", "AnalogMarker", "High", "Low", "AnalogInput", "AnalogOutput", "SOutput", "SAnalogOutput", "ShiftRegisterInput", "VirtualOutput", "DataLog"}, {"Base", "And", "Or", "Not", "Xor", "Nand", "Nor", "PecAnd", "PecNand"}, {"Special", "OnDelay", "OffDelay", "PulseRelay", "Clock", "LatchingRelay", "RetentiveOnDelay", "Counter", "HoursCounter", "WipingRelay", "Trigger", "AsymPulseGenerator", "YearClock", "OnOffDelay", "Random", "StairsSwitch", "ComfortSwitch", "WipingRelayPEC", "Message", "AnalogTrigger", "AnalogComparator", "Amplifier", "AnalogWatchdog", "AnalogDeltaTrigger", "ShiftRegister", "Softkey", "PID", "AnalogMux", "RampControl", "AnalogMaths", "MathDetection", "PWM", "AstronomicalClock", "AnalogFilter", "AverageValue", "MaxMin", "StopWatch"}, {"UDF", "Deputy"}};
        return sArr;
    }

    protected static void addPropertyItems(Hashtable dict) {
        Logo6Update1.addPropertyItems(dict);
        dict.put("RTFMaxIOStatusItem", 8);
        dict.put("RTFMaxIOStatusItemTotal", 40);
        dict.put("TypeInStatusName", new int[]{6, 7, 10, 21, 17, 19, 0});
        dict.put("maxPAEncodingCountInUDF", 112);
        dict.put("RTFMaxTimeScale", 4);
        dict.put("RTFMaxTimeScaleTotal", 32);
        dict.put("dataTableMaximumLength", 25);
        dict.put("dataTransferNumber", 32);
        dict.put("blockVMMappingNumber", 64);
        dict.put("maximumConnections", 8);
        dict.put("VMSizeInByte", 1024);
        dict.put("nStartAddress", 851);
        dict.put("anStartAddress", 859);
        dict.put("iStartAddress", 923);
        dict.put("aiStartAddress", 926);
        dict.put("qStartAddress", 942);
        dict.put("aqStartAddress", 944);
        dict.put("mStartAddress", 948);
        dict.put("amStartAddress", 952);
        dict.put("maximumDatalogRecords", 32);
    }

    protected static void addSupportItems(Hashtable dict) {
        Logo6Update1.addSupportItems(dict);
        dict.put("supportNetwork", Boolean.TRUE);
        dict.put("TimeValueAsReferenceSource", Boolean.TRUE);
        dict.put("DataLog", Boolean.TRUE);
        dict.put("supportScaleTime", Boolean.TRUE);
        dict.put("SupportMessageOnlineTest", Boolean.TRUE);
        dict.put("supportDataTable", Boolean.TRUE);
        dict.put("SupportParamSync", Boolean.TRUE);
        dict.put("commBlockModeWithoutAck", Boolean.TRUE);
        dict.put("masterSlave", Boolean.TRUE);
        dict.put("UDF", Boolean.TRUE);
        dict.put("supportTriggerAsParamSRC", Boolean.TRUE);
        dict.put("supportMenuItemInStartScreenProperty", Boolean.TRUE);
    }

    @Override
    protected int getOpcodeSF(String name) throws IllegalArgumentException {
        if (name.equals("AstronomicalClock")) {
            return 40;
        }
        if (name.equals("AnalogFilter")) {
            return 71;
        }
        if (name.equals("AverageValue")) {
            return 69;
        }
        if (name.equals("MaxMin")) {
            return 70;
        }
        if (name.equals("StopWatch")) {
            return 72;
        }
        return super.getOpcodeSF(name);
    }

    @Override
    public int getID() {
        return 80;
    }

    @Override
    public int getFirmwareID() {
        return 608;
    }

    @Override
    public int getNumberOfTransferBytes() {
        return 32000;
    }

    @Override
    protected int getActualDataOffset(int opcode) {
        switch (opcode) {
            case 1: {
                return 10;
            }
            case 2: {
                return 10;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 10;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 10;
            }
            case 8: {
                return 10;
            }
            case 52: {
                return 6;
            }
            case 56: {
                return 10;
            }
            case 69: {
                return 12;
            }
            case 70: {
                return 12;
            }
            case 71: {
                return 5;
            }
            case 72: {
                return 9;
            }
            case 40: {
                return 11;
            }
        }
        return super.getActualDataOffset(opcode);
    }

    @Override
    public CompilerFromHardware getCompilerFromHardware() {
        return new CompilerFromLogo7();
    }

    @Override
    protected int getChecksum() {
        int checksum = 0;
        checksum = (short)(checksum + this.getChecksumMemoryByWord(this.getMemory("EEPromIndexTable")));
        checksum = (short)(checksum + this.getChecksumAnchorMemories());
        checksum = (short)(checksum + this.getChecksumMemoryByWord(this.getMemory("Prog Index table")));
        MemoryEnumeration offsetTable = this.getMemory("ProgOffsetTabelle").elements();
        checksum = (short)(checksum + this.getChecksumProgramMemory(offsetTable));
        Memory udfMemory = this.getMemory("UDF Memory");
        if (udfMemory.getWord(0) > 0) {
            checksum = (short)(checksum + this.getChecksumMemoryByByte(udfMemory));
        }
        Memory networkMemory = this.getMemory("Network Memory");
        checksum = (short)(checksum + networkMemory.getChecksum());
        int result = checksum & 0xFFFF;
        return result;
    }

    protected final int getChecksumMemoryByWord(Memory memory) {
        int checksum = 0;
        for (int i = 0; i < memory.size() * memory.getBlockSize(); i += 2) {
            checksum = (short)(checksum + memory.getWord(i));
        }
        return checksum;
    }

    protected final int getChecksumMemoryByByte(Memory memory) {
        int checksum = 0;
        for (int i = 0; i < memory.size() * memory.getBlockSize(); ++i) {
            checksum = (short)(checksum + memory.get(i));
        }
        return checksum;
    }

    @Override
    protected int getAnchorMemoryValidLength(Memory mem) {
        return mem.getBlockSize();
    }

    @Override
    protected int getProgramLineAddressOffset() {
        return 0;
    }

    @Override
    public int getChecksum(WiringDiagram wd) {
        this.prepareMemories(wd);
        return super.getChecksum(wd);
    }

    @Override
    public CompilerToHardware getCompilerToHardware() {
        if (this.fCompilerToLogo == null) {
            this.fCompilerToLogo = new CompilerToLogo7();
        }
        return this.fCompilerToLogo;
    }

    @Override
    public LinkerToLogo getLinkerToHardware() {
        return new LinkerToLogo7(this);
    }

    @Override
    public ActualValueVisitor getActualValueVisitor() {
        return new ActualValueVisitorV7();
    }

    @Override
    public void prepareUpload(DataTransfer dt) throws ProgramException, ExceptionAlreadyHandledException {
        this.checkSDCard(dt);
        super.prepareUpload(dt);
        try {
            this.prepareMemories(dt);
        }
        catch (TransmissionFailedException e) {
            throw new ExceptionAlreadyHandledException();
        }
    }

    @Override
    public void downloadProgram(DataTransfer dt, WiringDiagram wd) throws ExceptionAlreadyHandledException {
        LogoError dlg;
        int dlgRet;
        boolean tryAgain;
        do {
            tryAgain = false;
            try {
                boolean ohcExisted;
                boolean bl = ohcExisted = (dt.readByte(this.getAdress(ADR_OHC_EXISTED)) & 1) == 1;
                if (ohcExisted && (dlgRet = (dlg = new LogoError(null, "msg.datatransfer.hoursCounterOverwritten", "Overwrite hours counter record?", 3, 1)).display()) != 0) {
                    return;
                }
            }
            catch (TransmissionFailedException tfe) {
                tryAgain = LogoError.checkRepeatTransmission(tfe);
                if (tryAgain) continue;
                throw new ExceptionAlreadyHandledException();
            }
        } while (tryAgain);
        super.downloadProgram(dt, wd);
        do {
            tryAgain = false;
            if (wd.getNetworkInfo().getIPAddress().length() <= 0) continue;
            try {
                if (dt instanceof VirtualDeviceDataTransfer || dt instanceof ImageFileDataTransfer) {
                    CommunicationSettingPanel.IPConfig config = new CommunicationSettingPanel.IPConfig();
                    config.values[1] = wd.getNetworkInfo().getIPAddress();
                    config.values[2] = wd.getNetworkInfo().getSubnetMask();
                    config.values[3] = wd.getNetworkInfo().getGateWay();
                    dt.setIPConfig(this.getIPAddressInEEprom(), config);
                    continue;
                }
                CommunicationSettingPanel.IPConfig preConfig = dt.getIPConfig(this.getIPAddressInEEprom());
                if (wd.getNetworkInfo().getIPAddress().equals(preConfig.values[1]) && wd.getNetworkInfo().getSubnetMask().equals(preConfig.values[2]) && wd.getNetworkInfo().getGateWay().equals(preConfig.values[3]) || (dlgRet = (dlg = new LogoError(null, "msg.datatransfer.IPSettingOverwritten", "Overwrite IP address setting?", 3, 1)).display()) != 0) continue;
                CommunicationSettingPanel.IPConfig config = new CommunicationSettingPanel.IPConfig();
                config.values[1] = wd.getNetworkInfo().getIPAddress();
                config.values[2] = wd.getNetworkInfo().getSubnetMask();
                config.values[3] = wd.getNetworkInfo().getGateWay();
                dt.setIPConfig(this.getIPAddressInEEprom(), config);
                dt.sendCommand(35);
            }
            catch (TransmissionFailedException tfe) {
                tryAgain = LogoError.checkRepeatTransmission(tfe);
                if (tryAgain) continue;
                throw new ExceptionAlreadyHandledException();
            }
        } while (tryAgain);
    }

    @Override
    public WiringDiagram uploadProgram(DataTransfer dt) throws ExceptionAlreadyHandledException, ProgramException {
        WiringDiagram ret = super.uploadProgram(dt);
        try {
            CommunicationSettingPanel.IPConfig config = dt.getIPConfig(this.getIPAddressInEEprom());
            ret.getNetworkInfo().setIPAddress(config.values[1]);
            ret.getNetworkInfo().setSubnetMask(config.values[2]);
            ret.getNetworkInfo().setGateWay(config.values[3]);
        }
        catch (TransmissionFailedException e) {
            throw new ExceptionAlreadyHandledException();
        }
        return ret;
    }

    public int getIPAddressInEEprom() {
        return 4881;
    }

    @Override
    protected int getQueryTimeToClearEEProm() {
        return 6;
    }

    @Override
    public Hardware prepareDownload(DataTransfer dt, WiringDiagram wd) throws ProgramException, ExceptionAlreadyHandledException {
        Hardware ret = super.prepareDownload(dt, wd);
        if (wd.getHardware() instanceof Logo7) {
            ((Logo7)wd.getHardware()).prepareMemories(wd);
        }
        return ret;
    }

    public void prepareMemories(DataTransfer dt) throws TransmissionFailedException {
        Vector<Memory> memories = new Vector<Memory>();
        this.addStaticMemories(memories);
        Memory indexMemory = memories.get(0);
        indexMemory.upload(dt);
        indexMemory.setPosition(0);
        int segCount = indexMemory.nextWord();
        if (segCount < 5) {
            System.err.println("invalid EEProm");
        }
        indexMemory.setPosition(14);
        int udfAddress = indexMemory.nextWord();
        int udfSize = indexMemory.nextWord();
        memories.add(new Memory("UDF Memory", udfAddress, 1, udfSize));
        int networkAddress = indexMemory.nextWord();
        int networkSize = indexMemory.nextWord();
        memories.add(new NetworkMemoryV7("Network Memory", networkAddress, 1, networkSize));
        int logProfileAddress = indexMemory.nextWord();
        int logProfileSize = indexMemory.nextWord();
        if (logProfileSize > 2) {
            memories.add(new Memory("Datalog Profile Memory", logProfileAddress + 2, 1, logProfileSize - 2));
        }
        this.fMemories = new Memory[memories.size()];
        memories.toArray(this.fMemories);
    }

    public void prepareMemories(WiringDiagram wd) {
        Vector<Memory> memories = new Vector<Memory>();
        this.addStaticMemories(memories);
        int[] usedResource = wd.getUsedResources();
        int udfTypeCount = usedResource[24];
        int topUdfCount = 0;
        Vector blocks = wd.getBlocks();
        for (Object block : blocks) {
            if (!(block instanceof UDFBlock)) continue;
            ++topUdfCount;
        }
        int UDFAddress = this.getNextStartAddress(memories.lastElement());
        int UDFSize = 1814 + udfTypeCount * 86 + topUdfCount * 58;
        Memory udfMemory = new Memory("UDF Memory", UDFAddress, 1, UDFSize);
        memories.add(udfMemory);
        Memory indexMemory = memories.get(0);
        indexMemory.putWord(UDFAddress);
        indexMemory.putWord(UDFSize);
        this.fCompilerToLogo = null;
        int networkAddress = this.getNextStartAddress(udfMemory);
        int transferCount = 0;
        Vector<EthernetConnection> connections = wd.getNetworkInfo().getEthernetConnections();
        for (int i = 0; i < connections.size(); ++i) {
            EthernetConnection connection = connections.get(i);
            if (connection == null || !connection.isClient()) continue;
            transferCount += connection.getVMReadTransactions().size();
            transferCount += connection.getVMWriteTransactions().size();
        }
        NetworkMemoryV7 networkMemory = new NetworkMemoryV7(networkAddress, connections.size(), transferCount);
        memories.add(networkMemory);
        indexMemory.putWord(networkAddress);
        indexMemory.putWord(networkMemory.getBlockSize() * networkMemory.size());
        int logProfileAddress = this.getNextStartAddress(networkMemory);
        IndexMemory logDespMemory = new IndexMemory("Datalog Index Memory", logProfileAddress, 1, 2);
        memories.add(logDespMemory);
        logDespMemory.putWord(0);
        Memory logMemory = new Memory("Datalog Profile Memory", logProfileAddress + 2, 128, 1);
        memories.add(logMemory);
        indexMemory.putWord(logProfileAddress);
        indexMemory.putWord(130);
        this.fMemories = new Memory[memories.size()];
        memories.toArray(this.fMemories);
    }

    private int getNextStartAddress(Memory memory) {
        return memory.getOffsetAdress() + memory.size() * memory.getBlockSize();
    }

    private void addStaticMemories(Vector<Memory> memories) {
        int SET_START = 4864;
        int MSG_START = 5120;
        int PROG_START = 12597;
        int UDF_START = 23425;
        IndexMemory indexMemory = new IndexMemory("EEPromIndexTable", 4744, 15, 2);
        memories.add(indexMemory);
        indexMemory.putWord(7);
        indexMemory.putWord(4864);
        indexMemory.putWord(256);
        MessageMemoryRTF_V7 msgMemory = new MessageMemoryRTF_V7("Message RTF", 5120);
        memories.add(msgMemory);
        msgMemory.setAllByteAtOnce(true);
        indexMemory.putWord(5120);
        indexMemory.putWord(7477);
        IndexMemory programDespMemory = new IndexMemory("Prog Index table", 12597, 2, 2);
        memories.add(programDespMemory);
        programDespMemory.putWord(400);
        programDespMemory.putWord(100);
        int nrOfBlocknames = this.getMaxResource(15);
        memories.add(new Memory("BlocknamenTabelle", 12601, nrOfBlocknames, 2));
        memories.add(new Memory("Blocknamen", 12801, nrOfBlocknames, 8));
        int ANCHOR_START = 13601;
        int curAddress = 13601;
        memories.add(new AnchorMemory16V7("Anker Q1...Qi", curAddress, 1, 32, 65));
        memories.add(new AnchorMemory16V7("Merker", curAddress += 128, 1, 54, 129));
        memories.add(new AnchorMemory16V7("Datalog Anchor", curAddress += 224, 1, 8, 241));
        memories.add(new AnchorMemory16V7("Virtuelle Anker", curAddress += 32, 1, 128, 449));
        memories.add(new AnchorMemory16V7("Anker network Q1...Qi", curAddress += 128, 1, 128, 641));
        memories.add(new AnchorMemory16V7("AnalogOuput", curAddress += 256, 1, 4, 785));
        memories.add(new AnchorMemory16V7("AnalogMarker", curAddress += 32, 1, 32, 801));
        memories.add(new AnchorMemory16V7("Network AQ", curAddress += 64, 1, 32, 961));
        curAddress += 64;
        memories.add(new Memory16("ProgOffsetTabelle", 14625, this.getMaxResource(0), 2));
        ProgramMemory16 progMemory = new ProgramMemory16("Program", 15425, this.getMaxResource(14), 1);
        memories.add(progMemory);
        indexMemory.putWord(12597);
        indexMemory.putWord(10828);
    }

    @Override
    public Memory[] getMemories() {
        if (this.fMemories == null) {
            this.prepareMemories(this.fDownloadedWiringDiagram);
        }
        return this.fMemories;
    }

    @Override
    public int getAdress(int name) {
        if (name == 1362) {
            return 4864;
        }
        if (name == 1363) {
            return 4865;
        }
        if (name == ADR_AI_POS) {
            return 4870;
        }
        if (name == ADR_AQ_TYPE) {
            return 4871;
        }
        if (name == 271) {
            return 4880;
        }
        if (name == ADR_FIRMWARE_ID) {
            return 4900;
        }
        if (name == ADR_CHECKSUM) {
            return 4902;
        }
        if (name == ADR_PASSWORD) {
            return 4904;
        }
        if (name == ADR_PROGRAM_NAME) {
            return 4914;
        }
        if (name == ADR_SDCARD_FLAG) {
            return 16730366;
        }
        if (name == ADR_START_SCREEN) {
            return 4940;
        }
        if (name == ADR_OHC_EXISTED) {
            return ADR_OHC_EXISTED | 0xFF0000;
        }
        return super.getAdress(name);
    }

    @Override
    public int calculateBlockNumber(int opcode) throws IllegalArgumentException {
        if (opcode == 0) {
            throw new IllegalArgumentException("Illegal opcode: " + opcode);
        }
        if (opcode < 65) {
            return opcode;
        }
        if (opcode < 129) {
            return opcode - 64;
        }
        if (opcode < 241) {
            return opcode - 128;
        }
        if (opcode < 257) {
            return opcode - 240;
        }
        if (opcode < 289) {
            return opcode - 256;
        }
        if (opcode < 321) {
            return opcode - 288;
        }
        if (opcode < 449) {
            return opcode - 320;
        }
        if (opcode < 513) {
            return opcode - 448;
        }
        if (opcode < 577) {
            return opcode - 512;
        }
        if (opcode < 705) {
            return opcode - 576;
        }
        if (opcode < 766) {
            throw new IllegalArgumentException("Illegal opcode: " + opcode);
        }
        if (opcode == 766) {
            return 0;
        }
        if (opcode == 767) {
            return 0;
        }
        if (opcode < 785) {
            return opcode - 768;
        }
        if (opcode < 801) {
            return opcode - 784;
        }
        if (opcode < 833) {
            return opcode - 800;
        }
        if (opcode < 961) {
            return opcode - 832;
        }
        if (opcode < 993) {
            return opcode - 960;
        }
        if (opcode < 1025) {
            return 0;
        }
        throw new IllegalArgumentException("Illegal opcode: " + opcode);
    }

    @Override
    protected int getRealCOOpcode(String name, int blockNr) {
        if (name.equals("Input")) {
            return 1 + blockNr;
        }
        if (name.equals("Output")) {
            return 65 + blockNr;
        }
        if (name.equals("Marker")) {
            return 129 + blockNr;
        }
        if (name.equals("DataLog")) {
            return 241 + blockNr;
        }
        if (name.equals("KeyInput")) {
            return 257 + blockNr;
        }
        if (name.equals("TDFunctionKeyInput")) {
            return 289 + blockNr;
        }
        if (name.equals("ShiftRegisterInput")) {
            return 321 + blockNr;
        }
        if (name.equals("VirtualOutput")) {
            return 449 + blockNr;
        }
        if (name.equals("Low")) {
            return 766;
        }
        if (name.equals("High")) {
            return 767;
        }
        if (name.equals("AnalogInput")) {
            return 769 + blockNr;
        }
        if (name.equals("AnalogOutput")) {
            return 785 + blockNr;
        }
        if (name.equals("AnalogMarker")) {
            return 801 + blockNr;
        }
        if (name.equals("NetworkNode")) {
            return 513 + blockNr;
        }
        if (name.equals("AnalogNetworkNode")) {
            return 833 + blockNr;
        }
        if (name.equals("SOutput")) {
            return 641 + blockNr;
        }
        if (name.equals("SAnalogOutput")) {
            return 961 + blockNr;
        }
        throw new IllegalArgumentException();
    }

    public int getUDFRelatedOpcode(String blockName) {
        if (blockName.equals("UDF")) {
            return 153;
        }
        if (blockName.equals("Deputy")) {
            return 152;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void restartToApplyAIPosSetting(DataTransfer dt) {
    }

    @Override
    protected void downloadAddtionalInfo(DataTransfer dt) throws TransmissionFailedException {
        super.downloadAddtionalInfo(dt);
        dt.writeByte(this.getAdress(271), 0);
    }

    @Override
    protected DrawingProperties uploadAddtionalInfo(DataTransfer dt) throws TransmissionFailedException {
        DrawingProperties ret = super.uploadAddtionalInfo(dt);
        return ret;
    }

    @Override
    public int getResetTimeout() {
        return 5001;
    }

    @Override
    public CompileFromXml getCompilerFromXml() {
        return new CompileFromXmlUDF();
    }

    @Override
    public CompileParameterFromXml getParameterCompiler() {
        return CompileParameterFromXmlUDF.getInstance();
    }

    @Override
    public WiringDiagram compileWDFromXml(Document document) {
        return this.getCompilerFromXml().compile(this, document);
    }

    @Override
    public UDFBlock compileUDFBlockFromXml(Document document) {
        return this.getCompilerFromXml().compileUDFBlock(new Logo7UDF(), document);
    }

    private void checkSDCard(DataTransfer dt) throws ProgramException, ExceptionAlreadyHandledException {
        int locked = 255;
        boolean tryAgain = false;
        do {
            tryAgain = false;
            try {
                locked = dt.readByte(this.getAdress(ADR_SDCARD_FLAG));
                if ((locked & CARD_PROTECTED) > 0) {
                    throw new ProgramException(Language.getString("error.program.copy-protected", "Program is copy-protected."));
                }
            }
            catch (TransmissionFailedException tfe) {
                tryAgain = LogoError.checkRepeatTransmission(tfe);
                if (tryAgain) continue;
                throw new ExceptionAlreadyHandledException();
            }
        } while (tryAgain);
    }

    public int getVMStartAddress(int blockType) {
        int ret = blockType == 6 ? this.getIntProperty("iStartAddress") : (blockType == 11 ? this.getIntProperty("aiStartAddress") : (blockType == 7 ? this.getIntProperty("qStartAddress") : (blockType == 13 ? this.getIntProperty("aqStartAddress") : (blockType == 10 ? this.getIntProperty("mStartAddress") : (blockType == 16 ? this.getIntProperty("amStartAddress") : (blockType == 22 ? this.getIntProperty("nStartAddress") : (blockType == 23 ? this.getIntProperty("anStartAddress") : -1)))))));
        return ret;
    }

    static {
        cSystemInfoDict.put("Logo7", Logo7.getSystemInfo());
    }

    private static class IndexMemory
    extends Memory16 {
        public IndexMemory(String name, int transferAdress, int memorySize, int blockSize) {
            super(name, transferAdress, memorySize, blockSize);
            super.init(255);
        }

        public void init(int initByte) {
        }
    }

    private static class BlockREMMemoryUsage
    extends MemoryUsageTable {
        private BlockREMMemoryUsage() {
        }

        protected void initializeTable() {
            this.put(OnDelayBlock.class, 3);
            this.put(OffDelayBlock.class, 3);
            this.put(PulseRelayBlock.class, 1);
            this.put(LatchingRelayBlock.class, 1);
            this.put(RetentiveOnDelayBlock.class, 3);
            this.put(HoursCounterBlock.class, 13);
            this.put(WipingRelayBlock.class, 3);
            this.put(CounterBlock.class, 5);
            this.put(AsymPulseGeneratorBlock.class, 3);
            this.put(OnOffDelayBlock.class, 3);
            this.put(StairsSwitchBlock.class, 3);
            this.put(ComfortSwitchBlock.class, 3);
            this.put(WipingRelayPECBlock.class, 4);
            this.put(SoftkeyBlock.class, 2);
            this.put(ShiftRegisterBlock.class, 1);
            this.put(PIDBlock.class, 2);
            this.put(AnalogMathsBlock.class, 2);
            this.put(AnalogWatchdogBlock.class, 3);
            this.put(MathDetectionBlock.class, 1);
            this.put(MaxMinBlock.class, 7);
            this.put(AverageValueBlock.class, 18);
            this.put(StopWatchBlock.class, 17);
        }
    }

    private static class BlockActualMemoryUsage
    extends MemoryUsageTable {
        private BlockActualMemoryUsage() {
        }

        protected void initializeTable() {
            this.put(OnDelayBlock.class, 4);
            this.put(OffDelayBlock.class, 6);
            this.put(PulseRelayBlock.class, 5);
            this.put(ClockBlock.class, 5);
            this.put(LatchingRelayBlock.class, 4);
            this.put(RetentiveOnDelayBlock.class, 6);
            this.put(HoursCounterBlock.class, 11);
            this.put(WipingRelayBlock.class, 4);
            this.put(CounterBlock.class, 10);
            this.put(TriggerBlock.class, 8);
            this.put(AsymPulseGeneratorBlock.class, 4);
            this.put(YearClockBlock.class, 2);
            this.put(OnOffDelayBlock.class, 6);
            this.put(RandomBlock.class, 6);
            this.put(StairsSwitchBlock.class, 4);
            this.put(ComfortSwitchBlock.class, 4);
            this.put(WipingRelayPECBlock.class, 6);
            this.put(MessageBlock.class, 2);
            this.put(AnalogTriggerBlock.class, 5);
            this.put(AnalogComparatorBlock.class, 11);
            this.put(SoftkeyBlock.class, 4);
            this.put(ShiftRegisterBlock.class, 2);
            this.put(AmplifierBlock.class, 4);
            this.put(AnalogWatchdogBlock.class, 9);
            this.put(AnalogDeltaTriggerBlock.class, 5);
            this.put(AnalogMuxBlock.class, 4);
            this.put(RampControlBlock.class, 14);
            this.put(PIDBlock.class, 15);
            this.put(AnalogMathsBlock.class, 4);
            this.put(PWMBlock.class, 7);
            this.put(MathDetectionBlock.class, 4);
            this.put(AstronomicalClockBlock.class, 4);
            this.put(AnalogFilterBlock.class, 4);
            this.put(AverageValueBlock.class, 4);
            this.put(MaxMinBlock.class, 4);
            this.put(StopWatchBlock.class, 8);
        }
    }

    private static class BlockMemoryUsage
    extends MemoryUsageTable {
        private BlockMemoryUsage() {
        }

        protected void initializeTable() {
            this.put(AndBlock.class, 12);
            this.put(OrBlock.class, 12);
            this.put(NotBlock.class, 8);
            this.put(NandBlock.class, 12);
            this.put(NorBlock.class, 12);
            this.put(XorBlock.class, 8);
            this.put(PecAndBlock.class, 12);
            this.put(PecNandBlock.class, 12);
            this.put(OnDelayBlock.class, 12);
            this.put(OffDelayBlock.class, 16);
            this.put(PulseRelayBlock.class, 12);
            this.put(ClockBlock.class, 24);
            this.put(LatchingRelayBlock.class, 12);
            this.put(RetentiveOnDelayBlock.class, 16);
            this.put(HoursCounterBlock.class, 36);
            this.put(WipingRelayBlock.class, 12);
            this.put(CounterBlock.class, 32);
            this.put(TriggerBlock.class, 20);
            this.put(AsymPulseGeneratorBlock.class, 16);
            this.put(YearClockBlock.class, 12);
            this.put(OnOffDelayBlock.class, 16);
            this.put(RandomBlock.class, 16);
            this.put(StairsSwitchBlock.class, 16);
            this.put(ComfortSwitchBlock.class, 20);
            this.put(WipingRelayPECBlock.class, 20);
            this.put(MessageBlock.class, 12);
            this.put(AnalogTriggerBlock.class, 20);
            this.put(AnalogComparatorBlock.class, 24);
            this.put(SoftkeyBlock.class, 12);
            this.put(ShiftRegisterBlock.class, 16);
            this.put(AmplifierBlock.class, 12);
            this.put(AnalogWatchdogBlock.class, 24);
            this.put(AnalogDeltaTriggerBlock.class, 20);
            this.put(AnalogMuxBlock.class, 20);
            this.put(RampControlBlock.class, 40);
            this.put(PIDBlock.class, 44);
            this.put(AnalogMathsBlock.class, 24);
            this.put(PWMBlock.class, 32);
            this.put(MathDetectionBlock.class, 16);
            this.put(AstronomicalClockBlock.class, 20);
            this.put(AnalogFilterBlock.class, 20);
            this.put(AverageValueBlock.class, 32);
            this.put(MaxMinBlock.class, 20);
            this.put(StopWatchBlock.class, 28);
        }
    }
}

